module net.BurtonRadons.dig.common.groupBox;

private import net.BurtonRadons.dig.platform.canvas;

/** This widget wraps its contents with an inset line and a textual description. */
class GroupBox : Canvas
{
    private import net.BurtonRadons.dig.platform.base;
    private import net.BurtonRadons.dig.platform.control;
    
    /** Register with the parent and create the widget. */
    this (Control parent)
    {
        super (parent);
        onPaint.add (&digCommonDoPaint);
        doubleBuffer (false);
    }

    /** Set the caption. */
    void caption (char [] text)
    {
        digCommonCaption = text.dup;
        recalculate ();
    }

    override void recalculate ()
    {
        _HGDIOBJ font;
        _DWORD result;

        font = (_HANDLE) SendMessageA (digPlatformHWND, WM_GETFONT, 0, 0);
        SelectObject (digPlatformHDC, font);
        result = GetTabbedTextExtentA (digPlatformHDC, digCommonCaption, digCommonCaption.length, 0, null);
        digPlatformSuggestWidth = (result & 0xFFFF) + 19;
        digPlatformSuggestHeight = (result >> 16) + 6;
        digPlatformBorderSY = digPlatformSuggestHeight - digPlatformBorderY - 9;

        if (childCount ())
            digPlatformGridfit ();
        else
            digPlatformMoved ();
    }

protected:
/+
#ifdef DOXYGEN_IS_OUT_OF_ITS_LEAGUE
+/

    char [] digCommonCaption;

    /* Paint the object. */
    void digCommonDoPaint (Event e)
    {
        beginPaint ();
        groupboxDraw (0, 0, width (), height (), digCommonCaption);
        endPaint ();
    }

    override void digPlatformChildMoved (Control control)
    {
        digPlatformGridfit ();
        digPlatformMoved ();
    }

/+
#endif
+/
}

